/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeInfoScreen
extends Screen {
    private NaturesCompassScreen parentScreen;
    private Biome biome;
    private Button searchButton;
    private Button backButton;
    private String topBlock;
    private String fillerBlock;
    private String baseHeight;
    private String heightVariation;
    private String precipitation;
    private String temperature;
    private String rainfall;
    private String highHumidity;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, Biome biome) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)BiomeUtils.getBiomeNameForDisplay(biome), (Object[])new Object[0])));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.topBlock = I18n.func_135052_a((String)biome.func_242440_e().func_242502_e().func_204108_a().func_177230_c().func_149739_a(), (Object[])new Object[0]);
        this.fillerBlock = I18n.func_135052_a((String)biome.func_242440_e().func_242502_e().func_204109_b().func_177230_c().func_149739_a(), (Object[])new Object[0]);
        this.baseHeight = biome.func_185355_j() < -1.0f ? I18n.func_135052_a((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : (biome.func_185355_j() < 0.0f ? I18n.func_135052_a((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.func_185355_j() < 0.4 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : (biome.func_185355_j() < 1.0f ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]))));
        this.heightVariation = (double)biome.func_185360_m() < 0.3 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.func_185360_m() < 0.6 ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]));
        this.precipitation = biome.func_201851_b() == Biome.RainType.SNOW ? I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]) : (biome.func_201851_b() == Biome.RainType.RAIN ? I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]));
        this.temperature = (double)biome.func_242445_k() <= 0.5 ? I18n.func_135052_a((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.func_242445_k() <= 1.5 ? I18n.func_135052_a((String)"string.naturescompass.medium", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.func_76727_i() <= 0.0f ? I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.2 ? I18n.func_135052_a((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.3 ? I18n.func_135052_a((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.5 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.85 ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
        this.highHumidity = biome.func_76736_e() ? I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]);
    }

    public void func_231160_c_() {
        this.setupButtons();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(BiomeUtils.getBiomeNameForDisplay(this.biome)), (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_78256_a(BiomeUtils.getBiomeNameForDisplay(this.biome)) / 2), 20.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.topBlock"), (float)(this.field_230708_k_ / 2 - 100), 40.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.topBlock), (float)(this.field_230708_k_ / 2 - 100), 50.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.precipitation"), (float)(this.field_230708_k_ / 2 - 100), 70.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.precipitation), (float)(this.field_230708_k_ / 2 - 100), 80.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.baseHeight"), (float)(this.field_230708_k_ / 2 - 100), 100.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.baseHeight), (float)(this.field_230708_k_ / 2 - 100), 110.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.rainfall"), (float)(this.field_230708_k_ / 2 - 100), 130.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.rainfall), (float)(this.field_230708_k_ / 2 - 100), 140.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.fillerBlock"), (float)(this.field_230708_k_ / 2 + 40), 40.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.fillerBlock), (float)(this.field_230708_k_ / 2 + 40), 50.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.temperature"), (float)(this.field_230708_k_ / 2 + 40), 70.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.temperature), (float)(this.field_230708_k_ / 2 + 40), 80.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.heightVariation"), (float)(this.field_230708_k_ / 2 + 40), 100.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.heightVariation), (float)(this.field_230708_k_ / 2 + 40), 110.0f, 0x808080);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("string.naturescompass.highHumidity"), (float)(this.field_230708_k_ / 2 + 40), 130.0f, 0xFFFFFF);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(this.highHumidity), (float)(this.field_230708_k_ / 2 + 40), 140.0f, 0x808080);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.field_230710_m_.clear();
        this.backButton = (Button)this.func_230480_a_((Widget)new TransparentButton(10, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.back"), onPress -> this.field_230706_i_.func_147108_a((Screen)this.parentScreen)));
        this.searchButton = (Button)this.func_230480_a_((Widget)new TransparentButton(this.field_230708_k_ - 120, this.field_230709_l_ - 30, 110, 20, (ITextComponent)new TranslationTextComponent("string.naturescompass.search"), onPress -> this.parentScreen.searchForBiome(this.biome)));
    }
}

